/* - AdvancedServo-full -
 * This example simply displays the Phidget AdvancedServo information when it is attached and displays 
 * the servo positions, velocity, and current with a slider for position, velocity, and acceleration manipulation.
 *
 * Please note that this example was designed to work with only one Phidget AdvanceServo connected. 
 * For an example using multiple Phidget AdvancedServos, please see a "multiple" example in the 
 * AdvancedServos Examples folder.
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package AdvancedServo;

import com.phidgets.AdvancedServoPhidget;
import com.phidgets.PhidgetException;

import javax.swing.JOptionPane;

import listeners.*;

public class AdvancedServo extends javax.swing.JFrame {
    
    private static String runArgs[];
    private AdvancedServoPhidget advServo;
    private AdvServoAttachListener attach_listener;
    private AdvServoDetachListener detach_listener;
    private AdvServoErrorListener error_listener;
    private AdvServoCurrentListener current_listener;
    private AdvServoPositionListener position_listener;
    private AdvServoVelocityListener velocity_listener;
    
    /** Creates new form AdvancedServo */
    public AdvancedServo() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        attachedTxt = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        nameTxt = new javax.swing.JTextArea();
        jLabel2 = new javax.swing.JLabel();
        serialTxt = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        versionTxt = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        numServosTxt = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        jLabel6 = new javax.swing.JLabel();
        servoCmb = new javax.swing.JComboBox();
        actVelTxt = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        actPosTxt = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        currentTxt = new javax.swing.JTextField();
        jLabel9 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        posScrl = new javax.swing.JSlider();
        targetPosTxt = new javax.swing.JTextField();
        jLabel11 = new javax.swing.JLabel();
        jLabel12 = new javax.swing.JLabel();
        velScrl = new javax.swing.JSlider();
        targetVelTxt = new javax.swing.JTextField();
        jLabel13 = new javax.swing.JLabel();
        jLabel14 = new javax.swing.JLabel();
        accelScrl = new javax.swing.JSlider();
        accelTxt = new javax.swing.JTextField();
        jLabel15 = new javax.swing.JLabel();
        engagedChk = new javax.swing.JCheckBox();
        rampingChk = new javax.swing.JCheckBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("AdvancedServo - full");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosed(java.awt.event.WindowEvent evt) {
                formWindowClosed(evt);
            }
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("AdvancedServo Info"));

        attachedTxt.setEditable(false);

        jLabel1.setText("Attached:");

        nameTxt.setBackground(javax.swing.UIManager.getDefaults().getColor("TextField.disabledBackground"));
        nameTxt.setColumns(20);
        nameTxt.setEditable(false);
        nameTxt.setLineWrap(true);
        nameTxt.setRows(3);
        nameTxt.setTabSize(2);
        nameTxt.setWrapStyleWord(true);
        jScrollPane1.setViewportView(nameTxt);

        jLabel2.setText("Name:");

        serialTxt.setEditable(false);

        jLabel3.setText("Serial No.:");

        versionTxt.setEditable(false);

        jLabel4.setText("Version:");

        numServosTxt.setEditable(false);

        jLabel5.setText("Servos:");

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(35, 35, 35)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jLabel1)
                    .add(jLabel2)
                    .add(jLabel4)
                    .add(jLabel3)
                    .add(jLabel5))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, numServosTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, versionTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, serialTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, attachedTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jScrollPane1))
                .addContainerGap(64, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(attachedTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel1))
                .add(15, 15, 15)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel2))
                .add(16, 16, 16)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(serialTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel3))
                .add(16, 16, 16)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(versionTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel4))
                .add(15, 15, 15)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(numServosTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel5))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Servo Data"));

        jLabel6.setText("Choose Servo:");

        servoCmb.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                servoCmbActionPerformed(evt);
            }
        });

        actVelTxt.setEditable(false);

        jLabel7.setText("Actual Velocity:");

        actPosTxt.setEditable(false);

        jLabel8.setText("Actual Position:");

        currentTxt.setEditable(false);

        jLabel9.setText("Current:");

        jLabel10.setText("Set Target Position:");

        posScrl.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                posScrlStateChanged(evt);
            }
        });

        targetPosTxt.setEditable(false);

        jLabel11.setText("Target Position:");

        jLabel12.setText("Set Velocity:");

        velScrl.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                velScrlStateChanged(evt);
            }
        });

        targetVelTxt.setEditable(false);

        jLabel13.setText("Target Velocity:");

        jLabel14.setText("Set Acceleration:");

        accelScrl.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                accelScrlStateChanged(evt);
            }
        });

        accelTxt.setEditable(false);

        jLabel15.setText("Acceleration:");

        engagedChk.setText("Engaged");
        engagedChk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                engagedChkActionPerformed(evt);
            }
        });

        rampingChk.setText("Speed Ramping");
        rampingChk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rampingChkActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel2Layout.createSequentialGroup()
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                                .add(org.jdesktop.layout.GroupLayout.LEADING, accelScrl, 0, 0, Short.MAX_VALUE)
                                .add(org.jdesktop.layout.GroupLayout.LEADING, posScrl, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 155, Short.MAX_VALUE)
                                .add(org.jdesktop.layout.GroupLayout.LEADING, jLabel10)
                                .add(org.jdesktop.layout.GroupLayout.LEADING, jLabel12)
                                .add(org.jdesktop.layout.GroupLayout.LEADING, velScrl, 0, 0, Short.MAX_VALUE))
                            .add(jLabel14))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 39, Short.MAX_VALUE)
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel15)
                            .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                                .add(jLabel13)
                                .add(org.jdesktop.layout.GroupLayout.TRAILING, targetVelTxt)
                                .add(jLabel11)
                                .add(targetPosTxt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 103, Short.MAX_VALUE)
                                .add(accelTxt))))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel2Layout.createSequentialGroup()
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel6)
                            .add(jLabel7)
                            .add(jLabel8)
                            .add(jLabel9)
                            .add(engagedChk))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 83, Short.MAX_VALUE)
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(rampingChk)
                            .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                                .add(org.jdesktop.layout.GroupLayout.LEADING, currentTxt)
                                .add(org.jdesktop.layout.GroupLayout.LEADING, actPosTxt)
                                .add(org.jdesktop.layout.GroupLayout.LEADING, actVelTxt)
                                .add(org.jdesktop.layout.GroupLayout.LEADING, servoCmb, 0, 140, Short.MAX_VALUE)))))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel6)
                    .add(servoCmb, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(actVelTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel7))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(actPosTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel8))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(currentTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel9))
                .add(18, 18, 18)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(engagedChk)
                    .add(rampingChk))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 12, Short.MAX_VALUE)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel10)
                    .add(jLabel11))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(posScrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(targetPosTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel12)
                    .add(jLabel13))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(targetVelTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(velScrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel14)
                    .add(jLabel15))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(accelScrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(accelTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {jPanel1, jPanel2}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * initialize the advanced servo object and hook the event listeners
     **/
    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
        
        posScrl.setEnabled(false);
        velScrl.setEnabled(false);
        accelScrl.setEnabled(false);
        servoCmb.setEnabled(false);
        
        try
        {
            advServo = new AdvancedServoPhidget();
            
            attach_listener = new AdvServoAttachListener(this, this.attachedTxt,
                    this.nameTxt, this.serialTxt, this.versionTxt,
                    this.numServosTxt, this.servoCmb, this.actVelTxt,
                    this.actPosTxt, this.currentTxt, this.posScrl,
                    this.targetPosTxt, this.velScrl, this.targetVelTxt,
                    this.accelScrl, this.accelTxt, this.engagedChk, this.rampingChk);
            
            detach_listener = new AdvServoDetachListener(this, this.attachedTxt,
                    this.nameTxt, this.serialTxt, this.versionTxt,
                    this.numServosTxt, this.servoCmb, this.actVelTxt,
                    this.actPosTxt, this.currentTxt, this.posScrl,
                    this.targetPosTxt, this.velScrl, this.targetVelTxt,
                    this.accelScrl, this.accelTxt, this.engagedChk, this.rampingChk);
            
            error_listener = new AdvServoErrorListener(this);
            
            current_listener = new AdvServoCurrentListener(this.servoCmb, this.currentTxt);
            
            position_listener = new AdvServoPositionListener(this.servoCmb, this.actPosTxt);
            
            velocity_listener = new AdvServoVelocityListener(this.servoCmb, this.actVelTxt);
            
            advServo.addAttachListener(attach_listener);
            advServo.addDetachListener(detach_listener);
            advServo.addErrorListener(error_listener);
            advServo.addCurrentChangeListener(current_listener);
            advServo.addServoPositionChangeListener(position_listener);
            advServo.addServoVelocityChangeListener(velocity_listener);
            
            if((runArgs.length > 1) && (runArgs[1].equals("remote")))
            {
                advServo.open(Integer.parseInt(runArgs[0]), null);
            }
            else if(runArgs.length > 0)
            {
                advServo.open(Integer.parseInt(runArgs[0]));
            }
            else
            {
                advServo.openAny();
            }
            
            
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_formWindowOpened

    /**
     * this code will switch between the selected servos and display their 
     * position, velocity, accelertaion, and current data
     **/
    private void servoCmbActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_servoCmbActionPerformed
        if(servoCmb.isEnabled())
        {
            //Use a try-catch block around code where you are getting and displaying the servo data
            //if the current position state has yet to be set, it will throw a PhidgetException for value not set
            //you can use this to test this and to display that the value is unknown
            try
            {
                actPosTxt.setText(Double.toString(advServo.getPosition(((Integer)servoCmb.getSelectedItem()).intValue())));
                actVelTxt.setText(Double.toString(advServo.getVelocity(((Integer)servoCmb.getSelectedItem()).intValue())));
                currentTxt.setText(Double.toString(advServo.getCurrent(((Integer)servoCmb.getSelectedItem()).intValue())));
                
                posScrl.setValueIsAdjusting(true);
                posScrl.setValue((int)advServo.getPosition(((Integer)servoCmb.getSelectedItem()).intValue()));
                targetPosTxt.setText(Double.toString(advServo.getPosition(((Integer)servoCmb.getSelectedItem()).intValue())));
                posScrl.setValueIsAdjusting(false);
                
                velScrl.setValueIsAdjusting(true);
                velScrl.setValue((int)advServo.getMaxVelocity(((Integer)servoCmb.getSelectedItem()).intValue()));
                targetVelTxt.setText(Double.toString(advServo.getMaxVelocity(((Integer)servoCmb.getSelectedItem()).intValue())));
                velScrl.setValueIsAdjusting(false);
                
                accelScrl.setValueIsAdjusting(true);
                accelScrl.setValue((int)advServo.getAcceleration(((Integer)servoCmb.getSelectedItem()).intValue()));
                accelTxt.setText(Double.toString(advServo.getAcceleration(((Integer)servoCmb.getSelectedItem()).intValue())));
                accelScrl.setValueIsAdjusting(false);
                
                engagedChk.setSelected(advServo.getMotorOn(((Integer)servoCmb.getSelectedItem()).intValue()));
                rampingChk.setSelected(advServo.getSpeedRampingOn(((Integer)servoCmb.getSelectedItem()).intValue()));
            }
            catch(PhidgetException ex)
            {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
                
                actPosTxt.setText("Unknown");
                actVelTxt.setText("Unknown");
                currentTxt.setText("Unknown");
                
                posScrl.setValueIsAdjusting(true);
                posScrl.setValue(-22);
                targetPosTxt.setText(Integer.toString(posScrl.getValue()));
                posScrl.setValueIsAdjusting(false);
                
                velScrl.setValueIsAdjusting(true);
                velScrl.setValue(0);
                targetVelTxt.setText(Integer.toString(velScrl.getValue()));
                velScrl.setValueIsAdjusting(false);
                
                accelScrl.setValueIsAdjusting(true);
                accelScrl.setValue(0);
                accelTxt.setText(Integer.toString(accelScrl.getValue()));
                accelScrl.setValueIsAdjusting(false);
            }
        }
    }//GEN-LAST:event_servoCmbActionPerformed

    /**
     * Modify the servo position based on the value returned by the slider
     **/
    private void posScrlStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_posScrlStateChanged
        if(posScrl.isEnabled())
        {
            //A PhidgetException will be thrown if you try to set the position to any value NOT between -22 and 232
            try
            {
                advServo.setPosition(((Integer)servoCmb.getSelectedItem()).intValue(), (double)posScrl.getValue());
                targetPosTxt.setText(Integer.toString(posScrl.getValue()));
            }
            catch(PhidgetException ex)
            {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            }
        }
    }//GEN-LAST:event_posScrlStateChanged

    /**
     * Modify the servo velocity property based on the value returned by the slider
     **/
    private void velScrlStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_velScrlStateChanged
        if(velScrl.isEnabled())
        {
            try
            {
                advServo.setMaxVelocity(((Integer)servoCmb.getSelectedItem()).intValue(), (double)velScrl.getValue());
                targetVelTxt.setText(Integer.toString(velScrl.getValue()));
            }
            catch(PhidgetException ex)
            {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            }
        }
    }//GEN-LAST:event_velScrlStateChanged

    /**
     * Modify the servo velocity property based on the value returned by the slider
     **/
    private void accelScrlStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_accelScrlStateChanged
        if(accelScrl.isEnabled())
        {
            try
            {
                advServo.setAcceleration(((Integer)servoCmb.getSelectedItem()).intValue(), (double)accelScrl.getValue());
                accelTxt.setText(Integer.toString(accelScrl.getValue()));
            }
            catch(PhidgetException ex)
            {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            }
        }
    }//GEN-LAST:event_accelScrlStateChanged

    /**
     * When the application is terminating, close the Phidget.
     **/
    private void formWindowClosed(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosed
        try
        {
            //unhook the event listeners
            advServo.removeServoVelocityChangeListener(velocity_listener);
            advServo.removeServoPositionChangeListener(position_listener);
            advServo.removeCurrentChangeListener(current_listener);
            advServo.removeErrorListener(error_listener);
            advServo.removeDetachListener(detach_listener);
            advServo.removeAttachListener(attach_listener);
            
            //close the phidget
            advServo.close();
            
            advServo = null;
            
            dispose();
            System.exit(0);
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            dispose();
            System.exit(0);
        }
    }//GEN-LAST:event_formWindowClosed

    private void engagedChkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_engagedChkActionPerformed
        try {
            advServo.setMotorOn(((Integer) servoCmb.getSelectedItem()).intValue(), engagedChk.isSelected());//GEN-LAST:event_engagedChkActionPerformed
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }

    private void rampingChkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rampingChkActionPerformed
        try
        {
            advServo.setSpeedRampingOn(((Integer) servoCmb.getSelectedItem()).intValue(), rampingChk.isSelected());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_rampingChkActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        runArgs = args;
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new AdvancedServo().setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSlider accelScrl;
    private javax.swing.JTextField accelTxt;
    private javax.swing.JTextField actPosTxt;
    private javax.swing.JTextField actVelTxt;
    private javax.swing.JTextField attachedTxt;
    private javax.swing.JTextField currentTxt;
    private javax.swing.JCheckBox engagedChk;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea nameTxt;
    private javax.swing.JTextField numServosTxt;
    private javax.swing.JSlider posScrl;
    private javax.swing.JCheckBox rampingChk;
    private javax.swing.JTextField serialTxt;
    private javax.swing.JComboBox servoCmb;
    private javax.swing.JTextField targetPosTxt;
    private javax.swing.JTextField targetVelTxt;
    private javax.swing.JSlider velScrl;
    private javax.swing.JTextField versionTxt;
    // End of variables declaration//GEN-END:variables
    
}
